/*
 * Decompiled with CFR 0.152.
 */
package com.deokma.MoltenVents.world;

import com.deokma.MoltenVents.MoltenVents;
import com.deokma.MoltenVents.MoltenVentsBiomeModification;
import com.deokma.MoltenVents.core.MoltenVentsConfiguredData;
import com.deokma.MoltenVents.world.MoltenVentConfiguration;
import com.deokma.MoltenVents.world.MoltenVentFeature;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;

public class MoltenVentFeatures {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<class_2960, class_3031<?>> FEATURES = new HashMap();
    private static final List<String> CONFIGURED_FEATURE_FILENAMES = new ArrayList<String>();
    private static boolean isFirstLoad = true;

    public static void init() {
        MoltenVentFeatures.registerFeatures();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("molten_vents", "configured_features_preload");
            }

            public void method_14491(class_3300 manager) {
                if (isFirstLoad) {
                    CONFIGURED_FEATURE_FILENAMES.clear();
                    CONFIGURED_FEATURE_FILENAMES.addAll(MoltenVentFeatures.loadValidFeatureFilenames(manager));
                    MoltenVentsBiomeModification.registerBiomeModifications();
                    isFirstLoad = false;
                }
            }
        });
        MoltenVentFeatures.registerResourceReloadListeners();
    }

    private static void registerFeatures() {
        MoltenVentFeatures.registerFeature(new class_2960("molten_vents", "molten_vent"), new MoltenVentFeature(MoltenVentConfiguration.CODEC));
    }

    private static <T extends class_3031<?>> T registerFeature(class_2960 id, T feature) {
        FEATURES.put(id, feature);
        return (T)((class_3031)class_2378.method_10230((class_2378)class_7923.field_41144, (class_2960)id, feature));
    }

    private static void registerResourceReloadListeners() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new MoltenVentsConfiguredData());
    }

    public static List<String> getConfiguredFeatureFilenames() {
        return CONFIGURED_FEATURE_FILENAMES;
    }

    private static List<String> loadValidFeatureFilenames(class_3300 manager) {
        ArrayList<String> filenames = new ArrayList<String>();
        String folderPath = "worldgen/configured_feature";
        Map resources = manager.method_14488(folderPath, path -> path.method_12832().endsWith(".json"));
        for (class_2960 id : resources.keySet()) {
            Optional<JsonObject> jsonOpt = MoltenVentFeatures.parseJson(manager, id);
            if (!jsonOpt.isPresent() || !"molten_vents:molten_vent".equals(jsonOpt.get().get("type").getAsString())) continue;
            String filename = id.method_12832().substring(id.method_12832().lastIndexOf(47) + 1, id.method_12832().lastIndexOf(46));
            filenames.add(filename);
        }
        return filenames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<JsonObject> parseJson(class_3300 manager, class_2960 id) {
        try {
            Iterator iterator = manager.method_14489(id).iterator();
            while (iterator.hasNext()) {
                class_3298 resource = (class_3298)iterator.next();
                InputStream stream = resource.method_14482();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                    JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    if (json == null || !json.has("type")) continue;
                    Optional<JsonObject> optional = Optional.of(json);
                    return optional;
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            return Optional.empty();
        }
        catch (Exception e) {
            MoltenVents.LOGGER.error("Error processing {}: {}", (Object)id, (Object)e.getMessage());
        }
        return Optional.empty();
    }
}

